function x = SoftThresh(y, t)
% SoftThresh -- Apply Soft Threshold
%  Usage
%    x = SoftThresh(y,t)
%  Inputs
%    y     Noisy Data
%    t     Threshold
%  Outputs
%    x  =   0 if abs(y) < t.
%    x  =   (abs(y) - t)*y/abs(y) if abs(y) > t.

if ~isreal(t) || t < 0
    x = [];
    errordlg(' in SoftThresh lambda is not positive real. ')
    return;
end
res = (abs(y) - t);
res = (res + abs(res))/2;
x   =   exp(1i*angle(y)).*res;
if isreal(y)
    x = real(x);
end

%
% Copyright (c) 1993-5.  Jonathan Buckheit, David Donoho and Iain Johnstone
% modified by Michael Lustig for complex signals.

%  Part of Wavelab Version 850
%  Built Tue Jan  3 13:20:39 EST 2006
%  This is Copyrighted Material
%  For Copying permissions see COPYING.m
%  Comments? e-mail wavelab@stat.stanford.edu
